/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.MediaProvider;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class MediaProviders {
    private static final Set<MediaProvider> providers = new LinkedHashSet<MediaProvider>();

    private MediaProviders() {
    }

    public static synchronized void register(MediaProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        providers.add(provider);
    }

    public static @Nullable IMedia get(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        for (MediaProvider mediaProvider : providers) {
            IMedia media = mediaProvider.getMedia(stack);
            if (media == null) continue;
            return media;
        }
        return null;
    }
}

